/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: PNIOCMDEV_Functionlist.h $
   Last Modification:
    $Author: Matthias $
    $Modtime: 23.01.07 10:52 $
    $Revision: 1 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    PNIO CMDEV
    Task function list for configuration file

   Changes:

    Date        Author       Description
    ----------- ------------ ---------------------------------------------------------
    2009-09-07  B. Meyer     added startup parameter uiMinDeviceInterval and changed
                                startup parameter version to PNIO_CMDEV_STARTUP_PARAM_VERSION_V2

    2009-05-21  B. Meyer     changed startup parameters

**************************************************************************************/
/**
 * @file PNIOCMDEV_Functionlist.h
 * @brief PNIO CMDEV - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_PNIOCMDEV</code>
 * of task.
 */
#ifndef __PNIO_CMDEV_FUNCTIONLIST_H
#define __PNIO_CMDEV_FUNCTIONLIST_H


/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_RESULT
TaskExit_PNIOCMDEV
(
 TLR_VOID FAR* pvRsc
);

TLR_RESULT
TaskLeave_PNIOCMDEV
(
 TLR_VOID FAR* pvRsc,
 TLR_VOID FAR* pvLve
);

TLR_RESULT
TaskEnter_PNIOCMDEV
(
 TLR_VOID FAR* pvInit
);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define PNIO_CMDEV_STARTUP_PARAM_VERSION_V2 (2)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** task startup parameter */
typedef struct PNIO_CMDEV_STARTUPPARAMETER_Ttag  PNIO_CMDEV_STARTUPPARAMETER_T_V2;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct PNIO_CMDEV_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;

  /** maximum context management protocol machine
   *
   * The member defines the maximum number of context management protocol machines
   * of PROFINET IO-Device.
   */
  TLR_UINT    uiMaxCmdevPm;

  /** minimum cycle time supported according to GSDML-file
   *
   * GSDML-files parameter "MinDeviceInterval"
   */
  TLR_UINT    uiMinDeviceInterval;
};

/** @} */

#define PNIO_CMDEV_STARTUP_DEFAULT_MAX_PM  (1)

/*************************************************************************************/
#endif /* #ifndef __PNIO_CMDEV_FUNCTIONLIST_H */
